<?php

namespace UtillzCore\Inc\Src\Admin\Columns;

use \UtillzCore\Inc\Src\Traits\Singleton;

class Listing {

    use Singleton;

    function __construct() {

        add_filter( 'manage_edit-ulz_listing_columns', [ $this, 'columns' ] );
        add_action( 'manage_ulz_listing_posts_custom_column', [ $this, 'custom_columns' ], 10, 2 );
        add_filter( 'manage_edit-ulz_listing_sortable_columns', [ $this, 'sortable_columns' ] );
        add_filter( 'request', [ $this, 'sort_columns' ] );

    }

    public function columns( $columns ) {

        if ( ! is_array( $columns ) ) {
            $columns = [];
        }

        unset(
            $columns['title'],
            $columns['date'],
            $columns['author'],
            $columns['comments']
        );

        $columns['ulz_image'] = '&nbsp;';
        $columns['ulz_title'] = esc_html__( 'Title', 'utillz-core' );
        $columns['ulz_status'] = esc_html__( 'Status', 'utillz-core' );
        $columns['ulz_listing_category'] = esc_html__( 'Categories', 'utillz-core' );
        $columns['ulz_listing_region'] = esc_html__( 'Region', 'utillz-core' );
        $columns['ulz_listing_tag'] = esc_html__( 'Tags', 'utillz-core' );
        $columns['ulz_priority'] = esc_html__( 'Priority', 'utillz-core' );
        $columns['ulz_review'] = esc_html__( 'Review', 'utillz-core' );
        $columns['ulz_posted'] = esc_html__( 'Posted', 'utillz-core' );
        $columns['ulz_expires'] = esc_html__( 'Expires', 'utillz-core' );
        $columns['ulz_actions'] = esc_html__( 'Actions', 'utillz-core' );

        return $columns;

    }

    public function custom_columns( $column, $post_id ) {

        global $post;

        $listing = new \UtillzCore\Inc\Src\Listing\Listing( $post_id );

        switch ( $column ) {

            case 'ulz_image':

                $image = $listing->get_first_from_gallery('thumbnail');
                $image_url = get_the_post_thumbnail_url($listing->id, 'thumbnail');
                ?>

                <div class="ulz-column-image">
                    <?php if( $image ): ?>
                        <img src="<?php echo esc_url( $image ); ?>" alt="">
                    <?php else: ?>
                        <div class="ulz-dummy-image">
                            <?php echo utillz_core()->icon->get( 'image', 'material-icons' ); ?>
                        </div>
                    <?php endif; ?>
                </div><?php

                break;

            case 'ulz_title':

                $listing_type_id = get_post_meta( $post_id, 'ulz_listing_type', true );

                echo '<div class="ulz-edit-title">';
                    echo '<a href="' . esc_url( admin_url( 'post.php?post=' . $post_id . '&action=edit' ) ) . '" class="tips" data-tip="' . sprintf( esc_html__( 'ID: %d', 'utillz-core' ), intval( $post_id ) ) . '">' . esc_html( $post->post_title ) . '</a>';
                    if( $listing_type_id ) {
                        echo '<div class="ulz-edit-type"><a href="' . get_edit_post_link( $listing_type_id ) . '">' . esc_attr( get_post_meta( $listing_type_id, 'ulz_name_plural', true ) ) . '</a></div>';
                    }
                echo '</div>';

                break;

            case 'ulz_listing_region':

                $term_ids = get_post_meta( $post_id, 'ulz_listing_region' );
                $html = [];
                foreach( $term_ids as $term_id ) {
                    $term = get_term_by( 'id', $term_id, 'ulz_listing_region' );
                    if( $term ) {
                        $html[] = '<a href="' . get_edit_term_link( $term ) . '">' . $term->name . '</a>';
                    }
                }
                echo implode( ', ', $html );

                break;

            case 'ulz_listing_category':

                $term_ids = array_filter( get_post_meta( $post_id, 'ulz_listing_category' ) );

                $html = [];
                foreach( $term_ids as $term_id ) {
                    $term = get_term_by( 'id', $term_id, 'ulz_listing_category' );
                    if( $term ) {
                        $html[] = '<a href="' . get_edit_term_link( $term ) . '">' . $term->name . '</a>';
                    }
                }
                echo implode( ', ', $html );

                break;

            case 'ulz_listing_tag':

                $term_ids = get_post_meta( $post_id, 'ulz_listing_tag' );
                $html = [];
                foreach( $term_ids as $term_id ) {
                    $term = get_term_by( 'id', $term_id, 'ulz_listing_tag' );
                    if( $term ) {
                        $html[] = '<a href="' . get_edit_term_link( $term ) . '">' . $term->name . '</a>';
                    }
                }
                echo implode( ', ', $html );

                break;

            case 'ulz_priority':

                $priority = get_post_meta( $post_id, 'ulz_priority', true );

                echo $priority ? $priority : 0;

                break;

            case 'ulz_review':

                if( $listing->reviews->average ) {
                    echo '<span class="ulz-column-review-average">';
                    echo '<strong><i class="fas fa-star"></i>' . number_format( $listing->reviews->average, 2 ) . '</strong>';
                    echo '</span>';
                }
                break;

            case 'ulz_posted':

                echo '<div class="ulz-posted">';
                echo '<strong>' . esc_html( date_i18n( get_option( 'date_format' ), strtotime( $post->post_date ) ) ) . '</strong><span>';
                echo ( empty( $post->post_author ) ? esc_html__( 'by a guest', 'utillz-core' ) : sprintf( esc_html__( 'by %s', 'utillz-core' ), '<a href="' . esc_url( add_query_arg( 'author', $post->post_author ) ) . '">' . esc_html( get_the_author() ) . '</a>' ) ) . '</span>';
                echo '</div>';
                break;

            case 'ulz_expires':

                $expires = Ucore()->get('ulz_listing_expires');

                if ( $expires ) {
                    $datetime = new \DateTime();
                    $datetime->setTimezone( new \DateTimeZone('GMT') );
                    $datetime->setTimestamp( strtotime( $expires ) );
                    $datetime->setTimezone( new \DateTimeZone( wp_timezone_string() ) );
                    echo '<strong>' . $datetime->format( get_option( 'date_format' ) ) . '</strong>';
                } else {
                    echo '&ndash;';
                }
                break;

            case 'ulz_status':

                echo '<div class="ulz-post-status ulz-status-' . $post->post_status . '"><span>' . Ucore()->get_status( $post ) . '</span></div>';
                break;

            case 'ulz_actions':

                echo '<div class="ulz-actions">';
                $admin_actions = apply_filters( 'admin_edit_listing_actions', [], $post );

                if ( in_array( $post->post_status, [ 'pending', 'pending_payment' ], true ) && current_user_can( 'publish_post', $post_id ) ) {
                    $admin_actions['approve'] = [
                        'action' => 'approve',
                        'name'   => __( 'Approve', 'utillz-core' ),
                        'url'    => wp_nonce_url( add_query_arg( 'approve_listing', $post_id ), 'approve_listing' ),
                        'icon'    => 'fas fa-check',
                    ];
                }
                if ( 'trash' !== $post->post_status ) {
                    if ( current_user_can( 'read_post', $post_id ) ) {
                        $admin_actions['view'] = [
                            'action' => 'view',
                            'name'   => __( 'View', 'utillz-core' ),
                            'url'    => get_permalink( $post_id ),
                            'icon'    => 'fas fa-eye',
                        ];
                    }
                    if ( current_user_can( 'edit_post', $post_id ) ) {
                        $admin_actions['edit'] = [
                            'action' => 'edit',
                            'name'   => __( 'Edit', 'utillz-core' ),
                            'url'    => get_edit_post_link( $post_id ),
                            'icon'    => 'fas fa-pen',
                        ];
                    }
                    if( current_user_can( 'edit_post', $post_id ) ) {
                        $admin_actions['duplicate'] = [
                            'action' => 'duplicate',
                            'name' => esc_html__( 'Duplicate', 'utillz-core' ),
                            'url' => add_query_arg( ['duplicate' => '' ], get_edit_post_link( $post_id ) ),
                            'icon' => 'fas fa-clone',
                        ];
                    }
                    if ( current_user_can( 'delete_post', $post_id ) ) {
                        $admin_actions['delete'] = [
                            'action' => 'delete',
                            'name'   => __( 'Delete', 'utillz-core' ),
                            'url'    => get_delete_post_link( $post_id ),
                            'icon'    => 'fas fa-trash-alt',
                        ];
                    }
                }

                $admin_actions = apply_filters( 'ulz_admin_actions', $admin_actions, $post );

                foreach ( $admin_actions as $action ) {
                    if ( is_array( $action ) ) {
                        printf( '<a class="button button-icon tips icon-%1$s" href="%2$s" data-tip="%3$s"><i class="%4$s"></i></a>', esc_attr( $action['action'] ), esc_url( $action['url'] ), esc_attr( $action['name'] ), esc_html( $action['icon'] ) );
                    }else{
                        echo wp_kses_post( str_replace( 'class="', 'class="button ', $action ) );
                    }
                }

                echo '</div>';

                break;

        }
    }

    public function sortable_columns( $columns ) {

        $custom = [
            'ulz_posted'                     => 'date',
            'ulz_title'                      => 'title',
            'taxonomy-ulz_listing_category'  => 'title',
            'taxonomy-ulz_listing_region'    => 'title',
            'taxonomy-ulz_listing_tag'       => 'title',
            'ulz_location'                   => 'ulz_location',
            'ulz_expires'                    => 'ulz_expires',
        ];

        return wp_parse_args( $custom, $columns );

    }

    public function sort_columns( $vars ) {

        if ( isset( $vars['orderby'] ) ) {
            if ( 'ulz_expires' === $vars['orderby'] ) {
                $vars = array_merge(
                    $vars,
                    [
                        'meta_key' => 'ulz_listing_expires',
                        'orderby'  => 'meta_value',
                    ]
                );
            }elseif( 'ulz_location' === $vars['orderby'] ) {
                $vars = array_merge(
                    $vars,
                    [
                        'meta_key' => '_ulz_location',
                        'orderby'  => 'meta_value',
                    ]
                );
            }
        }

        return $vars;

    }

}
